<?php
session_start();

if(!$_SESSION['isadmin']) {
	header("Location: login.php?ref=edit.php?pageid=1");
	exit;
}

if($_SESSION['country_login'] == 1) {
	header("Location: index.php");
	exit;
}

include_once("../functions.php");

$conn = dbconnect();

include "headers/common_header.php";

$get_all_ts = mysqli_query($conn, "SELECT c.id as id,name, clubname,homeclub, amount, compdate, score, c.createdon, winneruser,spendon, sn.score,sn.paid,sn.updated_paid_on,sn.barcode,sn.clubid as cid from compbooking c, stickers_new sn WHERE mobile='".mysqli_real_escape_string($conn, $_GET['id'])."' AND c.barcodeid=sn.id ORDER by createdon ASC");

?>

<!--BEGIN PAGE WRAPPER-->

        <div id="page-wrapper"><!--BEGIN TITLE & BREADCRUMB PAGE-->

            <div id="title-breadcrumb-option-demo" class="page-title-breadcrumb">

                <div class="page-header pull-left">

                    <div class="page-title">Used TS for <?php echo $_GET['id']?></div>

                </div>

                <ol class="breadcrumb page-breadcrumb pull-right">

                    <li><i class="fa fa-home"></i>&nbsp;<a href="index.php">Home</a>&nbsp;&nbsp;<i class="fa fa-angle-right"></i>&nbsp;&nbsp;</li>

                    <li class="active">Used TS</li>

                </ol>

                <div class="clearfix"></div>

            </div>

            <!--END TITLE & BREADCRUMB PAGE-->

<!--BEGIN CONTENT TABLE-->

            <div class="page-content">
              <button id="exporttoexcel" style="float:right;border:1px solid black;margin:4px;">Download</button>
                <div class="row">

                    <div class="col-lg-12">

                        <div class="panel panel-green">

                            <div class="panel-heading">List of TS used by:<?php echo $_GET['id']?></div>

                           <div class="panel-body">

                                <div id="no-more-tables">

                                    <table class="table table-bordered table-striped table-condensed cf" id="players">

                                        <thead class="cf">

                                        <tr>

                                            <th>Sr. No.</th>
                                            <th class="numeric">Name</th>
                                            <th class="numeric">Homeclub</th>
                                            <th>Comp Date</th>
                                            <th>Status</th>	
                                            <th>Score</th>								
											<th class="numeric">Amount</th>
											<th class="numeric">Bookedon</th>
                                            <th class="numeric">Action</th>
                                            <th class="numeric">Spend On</th>
                                            	
                                        </tr>

                                        </thead>
                                        <tbody>
                                        <?php 
                                        
                                        $srno=1;
                                        while ($ts_info = mysqli_fetch_array($get_all_ts)) {
                                            ?>
                                        <tr>

                                            <td data-title="Sr. No."><?php echo $srno; ?></td>
                                            <td data-title="Name" class="numeric"><?php echo ucwords(strtolower($ts_info['name']))?></td>
											<td data-title="Clubname"><?php echo ucwords(strtolower($ts_info['homeclub']))?></td>
                                            <td data-title="Comp Date"><?php echo date('jS M Y', strtotime($ts_info['compdate']))?></td>
                                            <td data-title="Mobile"><?php echo get_status($ts_info['winneruser'])?></td>
                                            <td data-title="Mobile"><?php echo $ts_info['score']?></td>
                                            <td data-title="Mobile"><?php echo "$".$ts_info['amount']?></td>
                                            <td data-title="Mobile"><?php echo date('jS M Y H:i A', strtotime($ts_info['createdon']))?></td>

                                            <td style="text-align:center">

                                                <?php if($ts_info['paid']) echo "Paid on ".date('jS M Y',strtotime($ts_info['updated_paid_on']))."<br />"; ?>
                                                    
                                                <select name="win_status" id="select_<?php echo $ts_info['barcode'];?>" <?php if($ts_info['winneruser']==4) {?> disabled="disabled" <?php }?> onChange="update_status('<?php echo $ts_info['barcode'];?>', <?php echo $ts_info['cid']?>,$(this).val(),'<?php echo $ts_info['id'];?>')">
                                                    
                                                    <option value="2" <?php if($ts_info['winneruser']==2) {?> selected="selected" <?php }?>>No Updates</option>
                                                    <option value="5" <?php if($ts_info['winneruser']==5) {?> selected="selected" <?php }?>>Just Missed</option>
                                                    <option value="1" <?php if($ts_info['winneruser']==1) {?> selected="selected" <?php }?>>Won</option>
                                                    <option value="3" <?php if($ts_info['winneruser']==3) {?> selected="selected" <?php }?>>Check the result</option>
                                                    <option value="4" <?php if($ts_info['winneruser']==4) {?> selected="selected" <?php }?>>Paid</option>
                                        
                                                </select>
                                                <div id="status_<?php echo $ts_info['barcode'];?>"></div>          
											</td>

                                            <td style="text-align:center">
										        <select name="spend_on" onChange="update_spendon($(this).val(),'<?php echo $ts_info['id'];?>')">
                                                <option value="0" <?php if($ts_info['spendon']=='') {?> selected="selected"<?php }?>>-Select-</option>
                                                <?php
                                                $s=mysqli_query($conn,"SELECT * FROM spendon");
												while($spd=mysqli_fetch_array($s)){
												?>
                                                <option value="<?php echo $spd['spend']; ?>"
                                                <?php if($ts_info['spendon']==$spd['spend']) {?> selected="selected"<?php }?>
                                                ><?php echo $spd['spend']?></option>
                                                <?php
												}
												?>
											    </select>
											    <div id="spon_<?php echo $ts_info['id'];?>"></div>
										    </td>

                                        </tr>
                                        <?php
                                        $srno++;
                                        }?>
                                        </tbody>

                                    </table>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>
            <script src= "table_to_excel.js"></script> 
            <script>
                $(document).ready(function() {
                    $("#exporttoexcel").click(function(){
                        $("#players").table2excel({
                            filename: "Players",
                        });
                    });
                });
            </script>

            <script>
                function update_status(barcode, clubid, status, id) {
                $.ajax({
                    type: "GET",
                    url: 'update_status_sticker_ajax.php',
                    data: { club_id:clubid, barcode_num:barcode, sticker_status:status, barid:id},
                    beforeSend: function(){
                        $('#status_'+barcode).html("Saving");
                    },
                    success: function(data) {
                        $('#status_'+barcode).html(data);
                        $('#select_'+barcode).attr("disabled","disabled");
                    },
                    error: function() {
                        $('#status_'+barcode).html('Something went wrong');
                    },
                    complete: function() {
                        //$('#'+barcode).html(data);
                    }
                });
            }

            function update_spendon(sp, id) {
                $.ajax({
                    type: "GET",
                    url: 'update_spendon_sticker_ajax.php',
                    data: {spendon_status:sp, barid:id},
                    beforeSend: function(){
                        $('#spon_'+id).html("Saving");
                    },
                    success: function(data) {
                        $('#spon_'+id).html(data);
                    },
                    error: function() {
                        $('#spon_'+id).html('Something went wrong');
                    },
                    complete: function() {
                        //$('#'+barcode).html(data);
                    }
                });
            };

            </script>
            <!--END CONTENT-->

<?php 

function get_status($status) {
    switch ($status) {
        case 1:
            return "Won";
            break;
        case 2:
            return "Yet to know";
            break;
        case 3: 
            return "Claimed";
            break;
        case 4:
            return "Paid";
            break;
        case 5:
            return "Lost";
            break;
    }
}

include "footer.php";?>