// moment.js language configuration

// language : Moroccan Arabic (ar-ma)

// author : ElFadili Yassine : https://github.com/ElFadiliY

// author : Abdel Said : https://github.com/abdelsaid



(function (factory) {

    if (typeof define === 'function' && define.amd) {

        define(['moment'], factory); // AMD

    } else if (typeof exports === 'object') {

        module.exports = factory(require('../moment')); // Node

    } else {

        factory(window.moment); // Browser global

    }

}(function (moment) {

    return moment.lang('ar-ma', {

        months : "يناير_فبراير_مارس_أبريل_ماي_يونيو_يوليوز_غشت_شتنبر_أكتوبر_نونبر_دجنبر".split("_"),

        monthsShort : "يناير_فبراير_مارس_أبريل_ماي_يونيو_يوليوز_غشت_شتنبر_أكتوبر_نونبر_دجنبر".split("_"),

        weekdays : "الأحد_الإتنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت".split("_"),

        weekdaysShort : "احد_اتنين_ثلاثاء_اربعاء_خميس_جمعة_سبت".split("_"),

        weekdaysMin : "ح_ن_ث_ر_خ_ج_س".split("_"),

        longDateFormat : {

            LT : "HH:mm",

            L : "DD/MM/YYYY",

            LL : "D MMMM YYYY",

            LLL : "D MMMM YYYY LT",

            LLLL : "dddd D MMMM YYYY LT"

        },

        calendar : {

            sameDay: "[اليوم على الساعة] LT",

            nextDay: '[غدا على الساعة] LT',

            nextWeek: 'dddd [على الساعة] LT',

            lastDay: '[أمس على الساعة] LT',

            lastWeek: 'dddd [على الساعة] LT',

            sameElse: 'L'

        },

        relativeTime : {

            future : "في %s",

            past : "منذ %s",

            s : "ثوان",

            m : "دقيقة",

            mm : "%d دقائق",

            h : "ساعة",

            hh : "%d ساعات",

            d : "يوم",

            dd : "%d أيام",

            M : "شهر",

            MM : "%d أشهر",

            y : "سنة",

            yy : "%d سنوات"

        },

        week : {

            dow : 6, // Saturday is the first day of the week.

            doy : 12  // The week that contains Jan 1st is the first week of the year.

        }

    });

}));

