<?php
// CONFIG: Enable debug mode. This means we'll log requests into 'ipn.log' in the same directory.
// Especially useful if you encounter network errors or other intermittent problems with IPN (validation).
// Set this to 0 once you go live or don't require logging.
define("DEBUG", 1);
// Set to 0 once you're ready to go live
define("USE_SANDBOX", 0);
define("LOG_FILE", "ipn.log");

date_default_timezone_set("Australia/Sydney");
ini_set("date.timezone","Australia/Sydney");

include "functions.php";
$conn = dbconnect();

// Read POST data
// reading posted data directly from $_POST causes serialization
// issues with array data in POST. Reading raw POST data from input stream instead.
$raw_post_data = file_get_contents('php://input');
$raw_post_array = explode('&', $raw_post_data);
$myPost = array();
foreach ($raw_post_array as $keyval) {
	$keyval = explode ('=', $keyval);
	if (count($keyval) == 2)
		$myPost[$keyval[0]] = urldecode($keyval[1]);
}
// read the post from PayPal system and add 'cmd'
$req = 'cmd=_notify-validate';
if(function_exists('get_magic_quotes_gpc')) {
	$get_magic_quotes_exists = true;
}
foreach ($myPost as $key => $value) {
	if($get_magic_quotes_exists == true && get_magic_quotes_gpc() == 1) {
		$value = urlencode(stripslashes($value));
	} else {
		$value = urlencode($value);
	}
	$req .= "&$key=$value";
}
// Post IPN data back to PayPal to validate the IPN data is genuine
// Without this step anyone can fake IPN data
if(USE_SANDBOX == true) {
	$paypal_url = "https://www.sandbox.paypal.com/cgi-bin/webscr";
} else {
	$paypal_url = "https://www.paypal.com/cgi-bin/webscr";
}
$ch = curl_init($paypal_url);
if ($ch == FALSE) {
	return FALSE;
}
curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
curl_setopt($ch, CURLOPT_POSTFIELDS, $req);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
curl_setopt($ch, CURLOPT_FORBID_REUSE, 1);
if(DEBUG == true) {
	curl_setopt($ch, CURLOPT_HEADER, 1);
	curl_setopt($ch, CURLINFO_HEADER_OUT, 1);
}
// CONFIG: Optional proxy configuration
//curl_setopt($ch, CURLOPT_PROXY, $proxy);
//curl_setopt($ch, CURLOPT_HTTPPROXYTUNNEL, 1);
// Set TCP timeout to 30 seconds
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
curl_setopt($ch, CURLOPT_HTTPHEADER, array('Connection: Close'));
// CONFIG: Please download 'cacert.pem' from "http://curl.haxx.se/docs/caextract.html" and set the directory path
// of the certificate as shown below. Ensure the file is readable by the webserver.
// This is mandatory for some environments.
//$cert = __DIR__ . "./cacert.pem";
//curl_setopt($ch, CURLOPT_CAINFO, $cert);
$res = curl_exec($ch);
if (curl_errno($ch) != 0) // cURL error
	{
	if(DEBUG == true) {	
		error_log(date('[Y-m-d H:i e] '). "Can't connect to PayPal to validate IPN message: " . curl_error($ch) . PHP_EOL, 3, LOG_FILE);
	}
	curl_close($ch);
	exit;
} else {
		// Log the entire HTTP response if debug is switched on.
		if(DEBUG == true) {
			error_log(date('[Y-m-d H:i e] '). "HTTP request of validation request:". curl_getinfo($ch, CURLINFO_HEADER_OUT) ." for IPN payload: $req" . PHP_EOL, 3, LOG_FILE);
			error_log(date('[Y-m-d H:i e] '). "HTTP response of validation request: $res" . PHP_EOL, 3, LOG_FILE);
		}
		curl_close($ch);
}
// Inspect IPN validation result and act accordingly
// Split response headers and payload, a better way for strcmp
$tokens = explode("\r\n\r\n", trim($res));
$res = trim(end($tokens));

$myfile = fopen("paypal.txt", "w") or die("Unable to open file!");
$txt = print_r($_POST);
fwrite($myfile, $txt);
fclose($myfile);

if (strcmp ($res, "VERIFIED") == 0 && ($_POST['mc_gross']==55.00 || $_POST['mc_gross']==12.00 || $_POST['mc_gross']==45.00 || $_POST['mc_gross']==60.00)) {

		$to = $_POST['payer_email'];
		$subject = 'Purchase is successful';
		$message = "Hi ".ucfirst(strtolower($_POST['first_name'])).", <br /><br />your purchase is successful at targetscores.com.au. <br /><br />You can now submit your competition date on https://targetscores.com.au using mobile number ".$_POST['custom']." or simply SMS your full name prior to tee off to 0436 318 688 to reveal your Target Score instantly. <br /><br />You can use your mobile number for ".$_POST['option_selection1']." competition(s). There are no refunds if the competition is cancelled. You can't change competitions once you have entered your details. <br /><br />Please don't hesitate to contact us should you need any assistance. <br /><br /> Thank you, <br />Target Scores Team";
		$headers = 'From: help@targetscores.com.au'. "\r\n" .
		'Reply-To: help@targetscores.com.au'. "\r\n" .
		'Content-type: text/html; charset=iso-8859-1' . "\r\n".
		'X-Mailer: PHP/' . phpversion();				
		sendMail($to, $subject, $message, $headers);
		
	// assign posted variables to local variables
	$item_name = $_POST['item_name'];
	$item_number = $_POST['item_number'];
	$payment_status = $_POST['payment_status'];
	$payment_amount = $_POST['mc_gross'];
	$payment_currency = $_POST['mc_currency'];
	$txn_id = $_POST['txn_id'];
	$receiver_email = $_POST['receiver_email'];
	$payer_email = $_POST['payer_email'];
	
	// check whether the payment_status is Completed
	$isPaymentCompleted = true;
	if($payment_status == "Completed") {
		$isPaymentCompleted = true;
	}
	// check that txn_id has not been previously processed
	$isUniqueTxnId = false; 
	$param_type="s";
	$param_value_array = array($txn_id);
	$result = mysqli_num_rows(mysqli_query($conn,"SELECT id FROM paypal WHERE txn_id = '".$txn_id."'"));
	if($result==0) {
		$isUniqueTxnId = true;
	}	
	// check that receiver_email is your PayPal email
	// check that payment_amount/payment_currency are correct
    if ($isPaymentCompleted && $isUniqueTxnId) {
        $payer_email = mysqli_real_escape_string($conn, $_POST['payer_email']);
        $payer_id = mysqli_real_escape_string($conn, $_POST['payer_id']);
        $payer_status = mysqli_real_escape_string($conn, $_POST['payer_status']);
        $first_name = mysqli_real_escape_string($conn, $_POST['first_name']);
        $last_name = mysqli_real_escape_string($conn, $_POST['last_name']);
        $txn_id = mysqli_real_escape_string($conn, $_POST['txn_id']);
        $mc_currency = mysqli_real_escape_string($conn, $_POST['mc_currency']);
        $mc_gross = mysqli_real_escape_string($conn, $_POST['mc_gross']);
        $protection_eligibility = mysqli_real_escape_string($conn, $_POST['protection_eligibility']);
        $payment_gross = mysqli_real_escape_string($conn, $_POST['payment_gross']);
        $payment_status = mysqli_real_escape_string($conn, $_POST['payment_status']);
        $pending_reason = mysqli_real_escape_string($conn, $_POST['pending_reason']);
        $payment_type = mysqli_real_escape_string($conn, $_POST['payment_type']);
        $item_name = mysqli_real_escape_string($conn, $_POST['item_name']);
        $txn_type = mysqli_real_escape_string($conn, $_POST['txn_type']);
        $option_selection1 = mysqli_real_escape_string($conn, $_POST['option_selection1']);
        $payment_date = mysqli_real_escape_string($conn, $_POST['payment_date']);
        $business = mysqli_real_escape_string($conn, $_POST['business']);
        $receiver_id = mysqli_real_escape_string($conn, $_POST['receiver_id']);
        $notify_version = mysqli_real_escape_string($conn, $_POST['notify_version']);
        $custom = mysqli_real_escape_string($conn, $_POST['custom']);
        
        $custom1 = explode("#", $custom);
        $promo_code = $custom1[0];

        $firstTS = explode("_", $custom1[1]);

        if ($firstTS[1]=="firstTS") {
			$custom = $custom1[2];
			$firstScore= $firstTS[2];
            $firstPrize= $firstTS[3];
    	}
		else {
			$custom = $custom1[1];
			$firstScore= 0;
            $firstPrize= 0;
        }

		$custom = preg_replace("/^\+?+61/", '',$custom);
		$custom = ltrim($custom,"0");
		$custom = trim($custom);
	
		$verify_sign = mysqli_real_escape_string($conn,$_POST['verify_sign']);
		$createdon = date('Y-m-d H:i:s');
		
		//Check if user new or old
		$already_referred = mysqli_num_rows(mysqli_query($conn,"SELECT promocode FROM paypal WHERE custom='".$custom."'"));
		
		//Old User
		if($already_referred > 0) {
			$already_referred_code = mysqli_fetch_array(mysqli_query($conn,"SELECT promocode FROM paypal WHERE custom='".$custom."' ORDER BY id ASC LIMIT 0,1"));
			$promo_code = $already_referred_code['promocode'];
		}
		//check if promocode is "firstTS"
	    if($firstTS[1]=="firstTS"){
	        $result = mysqli_num_rows(mysqli_query($conn,"SELECT id FROM compbooking WHERE mobile = '".$custom."'"));
                if ($result == 0 && $firstScore>0) {
	            	mysqli_query($conn,"INSERT INTO firstTS VALUES(0, '".$custom."', ".$firstScore.", ".$firstPrize.", 0,'".date('Y-m-d H:i:s')."','0000-00-00 00:00:00')");
                }
	    }
	    //insert into paypal
		mysqli_query($conn,"INSERT INTO paypal VALUES(0, '".$payer_email."', '".$payer_id."', '".$payer_status."', '".$first_name."', '".$last_name."', '".$txn_id."', '".$mc_currency."', '".$mc_gross."', '".$protection_eligibility."', '".$payment_gross."', '".$payment_status."', '".$pending_reason."', '".$payment_type."', '".$item_name."', '".$txn_type."', '".$option_selection1."', '".$payment_date."', '".$business."', '".$receiver_id."', '".$notify_version."', '".$custom."', '".$verify_sign."', '".$createdon."','".$promo_code."',0)");
		
        //get sms count//
        $mobile_sms_count = mysqli_fetch_array(mysqli_query($conn,"SELECT sms_count FROM less_balance WHERE mobile = '".$custom."'"));
        
        //insert into less_balance_payment//
        $pay_date = date('Y-m-d H:i:s');
        mysqli_query($conn,"INSERT INTO less_balance_payment VALUES(0,'".$custom."','".$mobile_sms_count['sms_count']."','".$pay_date."')");
		
		mysqli_query($conn,"DELETE FROM less_balance WHERE mobile = '".$custom."'");
		
		//delete the zero balance record//
		mysqli_query($conn,"DELETE FROM zero_balance WHERE mobile = '".$custom."'");
		
		$query = "INSERT INTO paypal VALUES(0, '".$payer_email."', '".$payer_id."', '".$payer_status."', '".$first_name."', '".$last_name."', '".$txn_id."', '".$mc_currency."', '".$mc_gross."', '".$protection_eligibility."', '".$payment_gross."', '".$payment_status."', '".$pending_reason."', '".$payment_type."', '".$item_name."', '".$txn_type."', '".$option_selection1."', '".$payment_date."', '".$business."', '".$receiver_id."', '".$notify_version."', '".$custom."', '".$verify_sign."', '".$createdon."','".$promo_code."',0)";
		
		error_log(date('[Y-m-d H:i e] '). "Query: $query ". PHP_EOL, 3, LOG_FILE);
		
		//update subscribe on date and status//
		if($_POST['mc_gross']==45.00){
		mysqli_query($conn,"UPDATE subscribers SET subscribe_on = '".date('Y-m-d H:i:s')."',paid=1 WHERE mobile = '".$custom."'");
		}
		
		//update comp-membership date and status//
		if($_POST['mc_gross']==60.00){
		mysqli_query($conn,"UPDATE comp_membership SET membership_on = '".date('Y-m-d H:i:s')."',paid=1 WHERE mobile = '".$custom."'");
		}
		
		//check existing target scores
		$chances = mysqli_fetch_array(mysqli_query($conn,"SELECT chances FROM targetscores WHERE mob = '".$custom."'"));
		$chances = $chances['chances'];

			//check it is refered number
			$ref_mobile = mysqli_fetch_array(mysqli_query($conn,"SELECT referred_mobile,referrer_mobile FROM referrals WHERE referred_mobile ='".$custom."' AND processed=0  ORDER BY id ASC LIMIT 0,1"));
				if($ref_mobile['referred_mobile']){
					
					//update TS for the refered mobile
					//mysqli_query($conn, "UPDATE targetscores SET chances = chances+1 WHERE mob = '".$ref_mobile['referrer_mobile']."'");

					//update processed column
					//mysqli_query($conn, "UPDATE referrals SET processed = 1 WHERE referred_mobile='".$ref_mobile['referred_mobile']."'");
					
					//get name and mobile number
					$get_details = mysqli_fetch_array(mysqli_query($conn,"SELECT payer_email,first_name FROM `paypal` WHERE custom ='".$ref_mobile['referrer_mobile']."'"));

					//send mail 
					$to = $get_details['payer_email'];
					$subject = 'Successful Target Score Referral';
					$message = "Hi ".ucfirst(strtolower($get_details['first_name'])).", <br /><br />Thanks so much for referring a friend and helping grow the TS community.<br /><br />You have been automatically credited a free Target Score and as part of our current offer your next Target Score will be 35 points to win $40!<br /><br />Please let us know when you plan to play next by sending us a quick email here:<a href><u>help@targetscores.com.au</u></a> <br /><br />Otherwise, we'll keep an eye out for your name, and after you reveal your next score we'll manually change it to 35 points. You'll be the envy of your group!<br /><br /> Play well and thanks again!<br /><br />TS Team";
					$headers = 'From: help@targetscores.com.au'. "\r\n" .
					'Reply-To: help@targetscores.com.au'. "\r\n" .
					'Content-type: text/html; charset=iso-8859-1' . "\r\n".
					'X-Mailer: PHP/' . phpversion();			
					//sendMail($to, $subject, $message, $headers);
                    
				}
		
		if(isset($chances)) {
			$newchances = $chances + $option_selection1;
			//update
			mysqli_query($conn,"UPDATE targetscores SET chances = ".$newchances." WHERE mob = '".$custom."'");
		} else {
			//insert
			mysqli_query($conn,"INSERT INTO targetscores VALUES (0, '".$custom."', ".$option_selection1.")");
		}
	} 
	// process payment and mark item as paid.
	
	
	if(DEBUG == true) {
		error_log(date('[Y-m-d H:i e] '). "Verified IPN: $req ". PHP_EOL, 3, LOG_FILE);
	}
	
} else if (strcmp ($res, "INVALID") == 0) {
	// log for manual investigation
	// Add business logic here which deals with invalid IPN messages
	if(DEBUG == true) {
		error_log(date('[Y-m-d H:i e] '). "Invalid IPN: $req" . PHP_EOL, 3, LOG_FILE);
	}
}
?>