<?php
session_start();

if(!$_SESSION['isadmin']) {
	header("Location: login.php?ref=edit.php?pageid=1");
	exit;
}

if($_SESSION['country_login'] == 1) {
	header("Location: index.php");
	exit;
}

include_once("../functions.php");

$conn = dbconnect();

include "headers/common_header.php";

$homeclubquery = mysqli_query($conn,"SELECT DISTINCT(homeclub) FROM `compbooking`");

?>



<!--BEGIN PAGE WRAPPER-->



        <div id="page-wrapper"><!--BEGIN TITLE & BREADCRUMB PAGE-->



            <div id="title-breadcrumb-option-demo" class="page-title-breadcrumb">



                <div class="page-header pull-left">



                    <div class="page-title">Booking Report</div>



                </div>



                <ol class="breadcrumb page-breadcrumb pull-right">



                    <li><i class="fa fa-home"></i>&nbsp;<a href="index.php">Home</a>&nbsp;&nbsp;<i class="fa fa-angle-right"></i>&nbsp;&nbsp;</li>



                    <li class="active">Booking Report</li>



                </ol>



                <div class="clearfix"></div>



            </div>

			<!--BEGIN CONTENT-->

            <div class="page-content">




                <div class="row">



                    <div class="col-lg-12">


                        <?php while($homeclub= mysqli_fetch_array($homeclubquery)) { ?>
                             

                        <div class="panel panel-red">

                            <div class="panel-heading"><?php echo $homeclub['homeclub']; ?></div>


                            <div class="panel-body">



                                <div id="no-more-tables">


                                    <table class="table table-bordered table-striped table-condensed cf"id="bookings" data-sortlist="[[0,1]]">



                                        <thead class="cf">



                                        <tr>

                                            <th class="numeric">Month</th>

                                            <th>Year</th>

											<th>Number of Bookings</th>

                                        </tr>

                                         
                                        <?php 
                                        $record = mysqli_query($conn,"SELECT MONTH(createdon) AS Month, year(createdon) AS Year, COUNT(id) AS bookings FROM `compbooking` WHERE homeclub = '".$homeclub['homeclub']."' GROUP BY MONTH(createdon), YEAR(createdon) ORDER BY YEAR(createdon),MONTH(createdon) ASC ");


                                        while($result = mysqli_fetch_array($record)) {
	
										?>

                                        </thead>

                                        <tbody>

                                        <tr>
                                             
                                            <td data-title="Month" class="numeric">
                                            <?php echo date('F', mktime(0, 0, 0, $result['Month'], 10)) ?>
                                            </td>

                                            <td data-title="Year">
                                            <?php echo $result['Year']; ?>
                                            </td>

											<td data-title="No Bookings">
                                            <?php echo $result['bookings']; ?>
                                            </td>

                                        </tr>

                                      </tbody>

                                    <?php } ?>

                                    </table>

                                </div>

                            </div>

                        </div>


                        <?php } ?> <!--while-->


                </div>

            </div>

            <!--END CONTENT-->
            <script src= "//cdn.rawgit.com/rainabba/jquery-table2excel/1.1.0/dist/jquery.table2excel.min.js"></script> 
            <script>
                $(document).ready(function() {
                    $("#exporttoexcel").click(function(){
                        $("#bookings").table2excel({
                            filename: "bookings_report",
                        });
                    });
                });
                
            </script>

<?php include "footer.php";?>