<?php
session_start();

if(!$_SESSION['isadmin'])
{
	header("Location: login.php?ref=edit.php?pageid=1");
	exit;
}

if($_SESSION['country_login'] == 1 || $_SESSION['country_login'] == 2) {
	header("Location: index.php");
	exit;
}

include_once("../functions.php");
$conn = dbconnect();

//Check if club country login and has access to this club
if($_SESSION['country_login'] == 1 && $_POST['golfclub']) {
	$has_access = mysqli_num_rows(mysqli_query($conn,"SELECT country FROM club_registrations WHERE id=".mysqli_real_escape_string($conn,$_POST['golfclub'])." AND country IN (".$_SESSION['country_access_array'].")"));
	
	if($has_access!==1) {
		header("Location: index.php");
		exit;
	}
}

include "headers/common_header.php";

if($_SESSION['country_login'] == 1) {
	$get_all_clubs = mysqli_query($conn,"SELECT * FROM club_registrations WHERE country IN (".$_SESSION['country_access_array'].") AND hideit=0 ORDER BY golfclub ASC");
} else {
	$get_all_clubs = mysqli_query($conn,"SELECT * FROM club_registrations WHERE hideit=0 ORDER BY golfclub ASC");
}
?>

<!--BEGIN PAGE WRAPPER-->

        <div id="page-wrapper"><!--BEGIN TITLE & BREADCRUMB PAGE-->

            <div id="title-breadcrumb-option-demo" class="page-title-breadcrumb">

                <div class="page-header pull-left">

                    <div class="page-title">Pack Report</div>

                </div>

                <ol class="breadcrumb page-breadcrumb pull-right">

                    <li><i class="fa fa-home"></i>&nbsp;<a href="index.php">Home</a>&nbsp;&nbsp;<i class="fa fa-angle-right"></i>&nbsp;&nbsp;</li>

                    <li class="active">Pack Report</li>

                </ol>

                <div class="clearfix"></div>

            </div>

            <!--END TITLE & BREADCRUMB PAGE-->

			<!--BEGIN CONTENT-->

            <div class="page-content">

                <div id="form-layouts" class="row">

                                    <div class="col-lg-12">

                                        <div class="panel panel-green">

                                            <div class="panel-heading">Please select club to see report:</div>

                                            <div class="panel-body pan">

                                                <form action="#" method="post" id="assign_stickers" class="form-horizontal">

                                                    <div class="form-body pal">

														<div class="form-group"><label for="country" class="col-md-3 control-label">Select Golf Club </label>

                                                            <div class="col-md-9">

                                                                <div class="input-icon">
																<select name="golfclub" class="form-control">
																<?php while($golf_club = mysqli_fetch_array($get_all_clubs)) {?>
                                                                <option <?php if($_POST['golfclub']==$golf_club['id']) {?> selected="selected" <?php }?> value="<?php echo $golf_club['id']?>"><?php echo $golf_club['golfclub']." ".$golf_club['businessname']?></option>
                                                                <?php }?>
                                                                </select>
                                                            </div>
                                                        </div>
                                                       </div>
													   
                                                        <div class="form-actions none-bg">

                                                        <div class="col-md-offset-3 col-md-9">

                                                           <input type="submit" name="get_report" value="Get Report" class="btn btn-primary">

                                                        </div>

                                                    </div>

                                                </form>

                                            </div>

                                        </div>

                                    </div>

                                </div>
								
								
								<div class="col-lg-12">

                                        <div class="panel panel-green">
										
										 <table class="table table-bordered table-striped table-condensed cf" style="width:100%">

                                        <thead class="cf">

                                        <tr>

											<th class="numeric" style="text-align:center">Sr.</th>
											
											<th class="numeric" style="text-align:center">Club</th>
											
											<th class="numeric" style="text-align:center">Pack Name</th>
											
											<th class="numeric" style="text-align:center">Series</th>
											
                                            <th class="numeric" style="text-align:center">$5</th>

                                            <th class="numeric" style="text-align:center">$10</th>

                                            <th class="numeric" style="text-align:center">Scratchies</th>

                                            <th class="numeric" style="text-align:center">Sold</th>
											
											<th class="numeric" style="text-align:center">Sold Cost</th>
											
											<th class="numeric" style="text-align:center">Days</th>
											
											<th class="numeric" style="text-align:center">Won</th>
											
											<th class="numeric" style="text-align:center">Prize Won</th>
											
											<th class="numeric" style="text-align:center">Winning %</th>

                                            <th class="numeric" style="text-align:center" width="20%">Invoice Status</th>
											
											<th class="numeric" style="text-align:center">See Scratchies</th>
											
											<!-- th class="numeric" style="text-align:center">DP</th>
											
											<th class="numeric" style="text-align:center">Commission</th>
											
											<th class="numeric" style="text-align:center">Cost</th>
											
											<th class="numeric" style="text-align:center">Delivery Cost</th>
											
											<th class="numeric" style="text-align:center">Total</th>
											
											<th class="numeric" style="text-align:center">Notes</th -->

                                        </tr>

                                        </thead>

                                        <tbody>
										<?php 
										//if($_POST['golfclub']) {
										
											if($_POST['golfclub']) {
												$get_clubs = mysqli_query($conn,"SELECT id, golfclub FROM club_registrations WHERE hideit=0 AND id=".$_POST['golfclub']);
											}
											else {
												$get_clubs = mysqli_query($conn,"SELECT id, golfclub FROM club_registrations WHERE hideit=0 ORDER BY golfclub ASC");
											}
											
											$sr=1;
											
											while($cid = mysqli_fetch_array($get_clubs)) {
										
											$club_id = mysqli_real_escape_string($conn,$cid['id']);
											
											//Get all the packs of this club.$_POST['golfclub']
											$get_all_packs = mysqli_query($conn,"SELECT distinct packname FROM stickers WHERE clubid=$club_id AND packname IN (SELECT packname FROM invoice_status WHERE cid=".$cid['id']." AND live=1) ORDER BY assignedon DESC");
											
											?>
											
											<!-- input type="button" value="Print or PDF" onclick="PrintElem('#mydiv')" style="float:right" / -->
											
											<div id="mydiv">
											
                                            <div class="panel-body pan">
												
												 <div id="no-more-tables">
                                   
																			
										<?php
										
										while($all_packs = mysqli_fetch_array($get_all_packs)) {
										
										//Check if $5 pack pr $10 pack
										
										$pack_cost = mysqli_fetch_array(mysqli_query($conn,"SELECT cost FROM stickers WHERE clubid=$club_id AND packname='".mysqli_real_escape_string($conn,$all_packs['packname'])."' LIMIT 0,1"));
										
										$total_scratchies = mysqli_num_rows(mysqli_query($conn,"SELECT id FROM stickers WHERE clubid=$club_id AND packname='".mysqli_real_escape_string($conn,$all_packs['packname'])."'"));
										$total_scratchies_sold = mysqli_num_rows(mysqli_query($conn,"SELECT id FROM stickers WHERE clubid=$club_id AND packname='".mysqli_real_escape_string($conn,$all_packs['packname'])."' AND sold=1"));
										$total_scratchies_sold_cost = mysqli_fetch_array(mysqli_query($conn,"SELECT sum(cost) as total_sold_cost FROM stickers WHERE clubid=$club_id AND packname='".mysqli_real_escape_string($conn,$all_packs['packname'])."' AND sold=1"));
										
										$total_scratchies_won = mysqli_num_rows(mysqli_query($conn,"SELECT id FROM stickers WHERE clubid=$club_id AND packname='".mysqli_real_escape_string($conn,$all_packs['packname'])."' AND won=1"));
										
										$total_scratchies_won_amount = mysqli_fetch_array(mysqli_query($conn,"SELECT sum(amount) as total_won_amount FROM stickers WHERE clubid=$club_id AND packname='".mysqli_real_escape_string($conn,$all_packs['packname'])."' AND won=1"));
										
										 	  //Sold in days
											 //number of strickers sold from last pack
											 $first_sold_from_last = mysqli_fetch_array(mysqli_query($conn,"SELECT date(updated_sold_on) as updated_sold_on FROM stickers WHERE clubid=$club_id AND packname='".mysqli_real_escape_string($conn,$all_packs['packname'])."' AND sold=1 ORDER BY updated_sold_on ASC LIMIT 0,1"));
											 $first_sold_from_last = $first_sold_from_last['updated_sold_on'];
											 
											 $last_sold_from_last = mysqli_fetch_array(mysqli_query($conn,"SELECT date(updated_sold_on) as updated_sold_on FROM stickers WHERE clubid=$club_id AND packname='".mysqli_real_escape_string($conn,$all_packs['packname'])."' AND sold=1 ORDER BY updated_sold_on DESC LIMIT 0,1"));
											 $last_sold_from_last = $last_sold_from_last['updated_sold_on'];
											 
											 
											$first_last = strtotime($first_sold_from_last);
											$last_last = strtotime($last_sold_from_last);
											$datediff_last = $last_last - $first_last;
											
											$last_days = floor($datediff_last / (60 * 60 * 24));
											
											//Winning %
											$total_amount_won = mysqli_fetch_array(mysqli_query($conn,"SELECT SUM(amount) as total_amount_won FROM stickers WHERE won=1 AND clubid=$club_id AND packname='".mysqli_real_escape_string($conn,$all_packs['packname'])."'"));
										
										//get total cost sold
										$total_sold_cost = mysqli_fetch_array(mysqli_query($conn,"SELECT SUM(cost) as total_cost_sold FROM stickers WHERE clubid=$club_id AND sold=1 AND packname='".mysqli_real_escape_string($conn,$all_packs['packname'])."'"));
										$total_sold_cost_use = $total_sold_cost['total_cost_sold'];

										$winning_percent = (100*$total_amount_won['total_amount_won'])/$total_sold_cost_use;
											
										//Invoice status
										$get_invoice_status = mysqli_fetch_array(mysqli_query($conn,"SELECT * FROM invoice_status WHERE cid=$club_id AND packname='".mysqli_real_escape_string($conn,$all_packs['packname'])."'"));
										
										//pack series
										$series = mysqli_fetch_array(mysqli_query($conn,"SELECT barcode FROM stickers WHERE clubid=".$cid['id']." AND packname='".$all_packs['packname']."' ORDER BY id ASC LIMIT 0,1"));
										
										?>
										
										<tr>
										<td><?php echo $sr;?></td>
										<td><?php echo $cid['golfclub']; ?></td>
										<td><?php echo $all_packs['packname']; ?></td>
										<td><?php echo substr($series['barcode'], 0, 5); ?>
										<td><?php if($pack_cost['cost']==5) echo "X"?></td>
										<td><?php if($pack_cost['cost']==10) echo "X"?></td>
										<td><?php echo $total_scratchies; ?></td>
										<td><?php echo $total_scratchies_sold; ?></td>
										<td><?php echo "$".$total_scratchies_sold_cost['total_sold_cost']; ?></td>
										<td><?php echo $last_days+1; ?></td>
										<td><?php echo $total_scratchies_won; ?></td>
										<td><?php echo "$".number_format($total_scratchies_won_amount['total_won_amount'], 0, '.', ','); ?></td>
										<td><?php echo number_format($winning_percent, 2, '.', ',')."%"; ?></td>
										<td align="center">
										<input type="hidden" id="clubid<?php echo $sr.$cid['id']; ?>" value="<?php echo $club_id; ?>">
										<input type="hidden" id="packname<?php echo $sr.$cid['id']; ?>" value="<?php echo base64_encode($all_packs['packname']); ?>">
										<input type="checkbox" id="sent_id<?php echo $sr.$cid['id']; ?>" <?php if($get_invoice_status['invoice_sent']==1) {?> checked="checked" <?php }?>> Sent | <input type="checkbox" id="paid_id<?php echo $sr.$cid['id']; ?>" <?php if($get_invoice_status['invoice_paid']==1) {?> checked="checked" <?php }?>> Paid | <input type="checkbox" id="live_id<?php echo $sr.$cid['id']; ?>" <?php if($get_invoice_status['live']==1) {?> checked="checked" <?php }?>> Live<br /> $<input type="text" id="invoice_amount<?php echo $sr.$cid['id']; ?>" size="10" value="<?php echo number_format($get_invoice_status['amount'], 0, '.', ','); ?>"> <input type="submit" id="<?php echo $club_id; ?>" value="Save" class="in_sent<?php echo $sr.$cid['id']; ?>" onclick="update_inv(<?php echo $sr; ?>,<?php echo $cid['id']?>)"><br /><span id="sent_container<?php echo $sr.$cid['id']?>" style="color:green; font-size:10px"></span>
										</td>
										<td><a href="see-stickers.php?cid=<?php echo $club_id;?>&packs=<?php echo base64_encode($all_packs['packname'])?>" style="color:#0000FF" target="_blank">See</a></td>
										
										</tr>
										
										
										<?php $sr++; }?>
										
										</div>
										<?php }?>
										</tbody>
										
										</table>
                                            </div>
											</div>

                                        </div>

                                    </div>

            <!--END CONTENT-->
			
<script type="text/javascript">

    function PrintElem(elem)
    {
        Popup($(elem).html());
    }

    function Popup(data) 
    {
        var mywindow = window.open('', 'golfsurprize.com', 'height=400,width=600');
        mywindow.document.write('<img src="../../images/logo@2x.png" width="250"/><html><head><title><?php echo $club_name['golfclub']?> Pack Report</title>');
        /*optional stylesheet*/ //mywindow.document.write('<link rel="stylesheet" href="main.css" type="text/css" />');
		
        mywindow.document.write('</head><body >');
        mywindow.document.write(data);
        mywindow.document.write('</body></html>');

        mywindow.document.close(); // necessary for IE >= 10
        mywindow.focus(); // necessary for IE >= 10

        mywindow.print();
        mywindow.close();

        return true;
    }

//$('.in_sent').click(function() {
function update_inv(idd, cid) {

	  var sent=0;
	  var paid=0;
	  var liveq=0;
	  var amount=$('#invoice_amount'+idd+cid).val();
	  var club=$('#clubid'+idd+cid).val();
	  var packname=$('#packname'+idd+cid).val();
	  
	  if ($('#sent_id'+idd+cid).is(":checked")) {
	  	sent=1;
	  }
	  
	   if ($('#live_id'+idd+cid).is(":checked")) {
	  	liveq=1;
	  }
	  
	  if ($('#paid_id'+idd+cid).is(":checked")) {
	  	paid=1;
	  }
	  
            $.ajax({
                type: "GET",
                url: 'update_invoice_status_ajax.php',
                data: { clubid:club, pack:packname, invoice_sent:sent, invoice_paid:paid, invoice_amt:amount, live_id:liveq },
				beforeSend: function(){
          		 	$('#sent_container'+idd+cid).html("Saving");
        		},
                success: function(data) {
                    //alert('it worked');
                    //alert(data);$(this).attr('id'),
                    $('#sent_container'+idd+cid).html(data);
                },
                 error: function() {
                    $('#sent_container').html("Error");
                },
                complete: function() {
                    ///$('#sent_container').html(data);
                }
            });

          
      };
</script>

<?php include "footer.php";?>