<?php
session_start();

if(!$_SESSION['isadmin']) {
	header("Location: login.php?ref=edit.php?pageid=1");
	exit;
}

if($_SESSION['country_login'] == 1) {
	header("Location: index.php");
	exit;
}

include_once("../functions.php");

$conn = dbconnect();

include "headers/common_header.php";

$get_all_entries = mysqli_query($conn,"SELECT DISTINCT name,email,mobile,count(id) AS entries FROM `2ndchancedraw` GROUP BY mobile ORDER BY entries DESC, name ASC");
?>

<!--BEGIN PAGE WRAPPER-->

        <div id="page-wrapper"><!--BEGIN TITLE & BREADCRUMB PAGE-->

            <div id="title-breadcrumb-option-demo" class="page-title-breadcrumb">

                <div class="page-header pull-left">

                    <div class="page-title">All Players</div>

                </div>

                <ol class="breadcrumb page-breadcrumb pull-right">

                    <li><i class="fa fa-home"></i>&nbsp;<a href="index.php">Home</a>&nbsp;&nbsp;<i class="fa fa-angle-right"></i>&nbsp;&nbsp;</li>

                    <li class="active">All players</li>

                </ol>

                <div class="clearfix"></div>

            </div>

            <!--END TITLE & BREADCRUMB PAGE-->

            <!--BEGIN CONTENT TABLE-->

            <div class="page-content">

            <button id="exporttoexcel" style="float:right;border:1px solid black;margin:4px;">Download</button>

                <div class="row">

                    <div class="col-lg-12">

                        <div class="panel panel-green">

                            <div class="panel-heading">All Players</div>

                           <div class="panel-body">

                                <div id="no-more-tables">

                                    <table class="table table-bordered table-striped table-condensed cf" id="players">

                                        <thead class="cf">

                                        <tr>

                                            <th>Sr. No.</th>

                                            <th class="numeric">Name</th>

                                            <th>Email</th>

                                            <th class="numeric">Mobile</th>

                                            <th>No Entries</th>

                                        </tr>

                                        </thead>

										<?php 

                                        $srno = 1;

                                        while($entry = mysqli_fetch_array($get_all_entries)){?>

                                        <tbody>

                                        <tr>

                                            <td data-title="Sr. No."><?php echo $srno; ?></td>

                                            <td data-title="Name" class="numeric"><?php echo $entry['name']?></td>

                                            <td data-title="Email"><?php echo $entry['email']?></td>

                                            <td data-title="Mobile" class="numeric"><?php echo $entry['mobile']?></td>

                                            <td data-title="No Entries" class="numeric"><?php echo $entry['entries']?></td>


                                        </tr>

                                        </tbody>

										<?php $srno++;}?>

                                    </table>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

            <!--END CONTENT-->

            <script src= "//cdn.rawgit.com/rainabba/jquery-table2excel/1.1.0/dist/jquery.table2excel.min.js"></script> 
            <script>
                $(document).ready(function() {
                    $("#exporttoexcel").click(function(){
                        $("#players").table2excel({
                            filename: "Players",
                        });
                    });
                });	
            </script>		

<?php include "footer.php";?>