<?php
// CONFIG: Enable debug mode. This means we'll log requests into 'ipn.log' in the same directory.
// Especially useful if you encounter network errors or other intermittent problems with IPN (validation).
// Set this to 0 once you go live or don't require logging.
define("DEBUG", 1);
// Set to 0 once you're ready to go live
define("USE_SANDBOX", 0);
define("LOG_FILE", "ipn.log");

date_default_timezone_set("Australia/Sydney");
ini_set("date.timezone","Australia/Sydney");

include "functions.php";
$conn = dbconnect_gsau();
$gs365 = dbconnect_gs365au();
//$ts =  dbconnect_targetscore();
include ("sms/api.php");

// Read POST data
// reading posted data directly from $_POST causes serialization
// issues with array data in POST. Reading raw POST data from input stream instead.
$raw_post_data = file_get_contents('php://input');
$raw_post_array = explode('&', $raw_post_data);
$myPost = array();
foreach ($raw_post_array as $keyval) {
	$keyval = explode ('=', $keyval);
	if (count($keyval) == 2)
		$myPost[$keyval[0]] = urldecode($keyval[1]);
}
// read the post from PayPal system and add 'cmd'
$req = 'cmd=_notify-validate';
if(function_exists('get_magic_quotes_gpc')) {
	$get_magic_quotes_exists = true;
}
foreach ($myPost as $key => $value) {
	if($get_magic_quotes_exists == true && get_magic_quotes_gpc() == 1) {
		$value = urlencode(stripslashes($value));
	} else {
		$value = urlencode($value);
	}
	$req .= "&$key=$value";
}
// Post IPN data back to PayPal to validate the IPN data is genuine
// Without this step anyone can fake IPN data
if(USE_SANDBOX == true) {
	$paypal_url = "https://www.sandbox.paypal.com/cgi-bin/webscr";
} else {
	$paypal_url = "https://www.paypal.com/cgi-bin/webscr";
}
$ch = curl_init($paypal_url);
if ($ch == FALSE) {
	return FALSE;
}
curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
curl_setopt($ch, CURLOPT_POSTFIELDS, $req);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
curl_setopt($ch, CURLOPT_FORBID_REUSE, 1);
if(DEBUG == true) {
	curl_setopt($ch, CURLOPT_HEADER, 1);
	curl_setopt($ch, CURLINFO_HEADER_OUT, 1);
}
// CONFIG: Optional proxy configuration
//curl_setopt($ch, CURLOPT_PROXY, $proxy);
//curl_setopt($ch, CURLOPT_HTTPPROXYTUNNEL, 1);
// Set TCP timeout to 30 seconds
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
curl_setopt($ch, CURLOPT_HTTPHEADER, array('Connection: Close'));
// CONFIG: Please download 'cacert.pem' from "http://curl.haxx.se/docs/caextract.html" and set the directory path
// of the certificate as shown below. Ensure the file is readable by the webserver.
// This is mandatory for some environments.
//$cert = __DIR__ . "./cacert.pem";
//curl_setopt($ch, CURLOPT_CAINFO, $cert);
$res = curl_exec($ch);
if (curl_errno($ch) != 0) // cURL error
	{
	if(DEBUG == true) {	
		error_log(date('[Y-m-d H:i e] '). "Can't connect to PayPal to validate IPN message: " . curl_error($ch) . PHP_EOL, 3, LOG_FILE);
	}
	curl_close($ch);
	exit;
} else {
		// Log the entire HTTP response if debug is switched on.
		if(DEBUG == true) {
			error_log(date('[Y-m-d H:i e] '). "HTTP request of validation request:". curl_getinfo($ch, CURLINFO_HEADER_OUT) ." for IPN payload: $req" . PHP_EOL, 3, LOG_FILE);
			error_log(date('[Y-m-d H:i e] '). "HTTP response of validation request: $res" . PHP_EOL, 3, LOG_FILE);
		}
		curl_close($ch);
}
// Inspect IPN validation result and act accordingly
// Split response headers and payload, a better way for strcmp
$tokens = explode("\r\n\r\n", trim($res));
$res = trim(end($tokens));

	$myfile = fopen("paypal.txt", "a") or die("Unable to open file!");
    $data = json_encode($_POST);
    fwrite($myfile,$data);
    fclose($myfile);



if (strcmp ($res, "VERIFIED") == 0 && ($_POST['mc_gross']==40.00)) {

		$to = $_POST['payer_email'];
		$subject = 'Welcome to the league';
		$message = "Hi ".ucfirst(strtolower($_POST['first_name'])).", <br /><br />Thank you for joining the league. You now have 4 credits, one for each round. To use a credit enter the tee time of your next Golf Surprize League Round here https://www.golfsurprize.au and you will receive an SMS/email with a link on game day. Please click the link and follow the instructions. You can enter your score on the same page. Have fun and win!<br /><br />Thank you, <br />Golf Surprize Team";
		$headers = 'From: pay@golfsurprize.com'. "\r\n" .
		'Reply-To: pay@golfsurprize.com'. "\r\n" .
		'Cc: info@golfsurprize.com'. "\r\n" .
		'Content-type: text/html; charset=iso-8859-1' . "\r\n".
		'X-Mailer: PHP/' . phpversion();				
		sendMail($to, $subject, $message, $headers);
		
	// assign posted variables to local variables
	$item_name = $_POST['item_name'];
	$item_number = $_POST['item_number'];
	$payment_status = $_POST['payment_status'];
	$payment_amount = $_POST['mc_gross'];
	$payment_currency = $_POST['mc_currency'];
	$txn_id = $_POST['txn_id'];
	$receiver_email = $_POST['receiver_email'];
	$payer_email = $_POST['payer_email'];
	
	// check whether the payment_status is Completed
	$isPaymentCompleted = true;
	if($payment_status == "Completed") {
		$isPaymentCompleted = true;
	}
	// check that txn_id has not been previously processed
	$isUniqueTxnId = false; 
	$param_type="s";
	$param_value_array = array($txn_id);
	$result = mysqli_num_rows(mysqli_query($conn,"SELECT id FROM paypal WHERE txn_id = '".$txn_id."'"));
	if($result==0) {
		$isUniqueTxnId = true;
	}	
	// check that receiver_email is your PayPal email
	// check that payment_amount/payment_currency are correct
    if ($isPaymentCompleted && $isUniqueTxnId) {
        $payer_email = mysqli_real_escape_string($conn, $_POST['payer_email']);
        $payer_id = mysqli_real_escape_string($conn, $_POST['payer_id']);
        $payer_status = mysqli_real_escape_string($conn, $_POST['payer_status']);
        $first_name = mysqli_real_escape_string($conn, $_POST['first_name']);
        $last_name = mysqli_real_escape_string($conn, $_POST['last_name']);
        $txn_id = mysqli_real_escape_string($conn, $_POST['txn_id']);
        $mc_currency = mysqli_real_escape_string($conn, $_POST['mc_currency']);
        $mc_gross = mysqli_real_escape_string($conn, $_POST['mc_gross']);
        $protection_eligibility = mysqli_real_escape_string($conn, $_POST['protection_eligibility']);
        $payment_gross = mysqli_real_escape_string($conn, $_POST['payment_gross']);
        $payment_status = mysqli_real_escape_string($conn, $_POST['payment_status']);
        $pending_reason = mysqli_real_escape_string($conn, $_POST['pending_reason']);
        $payment_type = mysqli_real_escape_string($conn, $_POST['payment_type']);
        $item_name = mysqli_real_escape_string($conn, $_POST['item_name']);
        $txn_type = mysqli_real_escape_string($conn, $_POST['txn_type']);
        $option_selection1 = mysqli_real_escape_string($conn, $_POST['option_selection1']);
        $payment_date = mysqli_real_escape_string($conn, $_POST['payment_date']);
        $business = mysqli_real_escape_string($conn, $_POST['business']);
        $receiver_id = mysqli_real_escape_string($conn, $_POST['receiver_id']);
        $notify_version = mysqli_real_escape_string($conn, $_POST['notify_version']);
        $custom = mysqli_real_escape_string($conn, $_POST['custom']);
        
        $custom1 = explode("__", $custom);
        $promo_code = $custom1[0];

        $firstTS = explode("_", $custom1[1]);

        if ($firstTS[1]=="firstTS") {
			$custom = $custom1[2];
			$firstScore= $firstTS[2];
            $firstPrize= $firstTS[3];
    	}
		else {
			$custom = $custom1[1];
			$firstScore= 0;
            $firstPrize= 0;
        }

		$custom = preg_replace("/^\+?+27/", '',$custom1[1]);
		$custom = ltrim($custom,"0");
		$custom = trim($custom);
	
		$verify_sign = mysqli_real_escape_string($conn,$_POST['verify_sign']);
		$createdon = date('Y-m-d H:i:s');
		
		$previous_promo = mysqli_fetch_array(mysqli_query($conn, "SELECT promocode FROM paypal WHERE custom='".$custom."' ORDER BY id ASC LIMIT 0,1"));
		if($previous_promo['promocode']!=="") {
		    $promo_code = $previous_promo['promocode'];
		}
				
	    //insert into paypal
		mysqli_query($conn,"INSERT INTO paypal VALUES(0, '".$payer_email."', '".$payer_id."', '".$payer_status."', '".$first_name."', '".$last_name."', '".$txn_id."', '".$mc_currency."', '".$mc_gross."', '".$protection_eligibility."', '".$payment_gross."', '".$payment_status."', '".$pending_reason."', '".$payment_type."', '".$item_name."', '".$txn_type."', '".$option_selection1."', '".$payment_date."', '".$business."', '".$receiver_id."', '".$notify_version."', '".$custom."', '".$verify_sign."', '".$createdon."','".$promo_code."',0)");
		
		$query = "INSERT INTO paypal VALUES(0, '".$payer_email."', '".$payer_id."', '".$payer_status."', '".$first_name."', '".$last_name."', '".$txn_id."', '".$mc_currency."', '".$mc_gross."', '".$protection_eligibility."', '".$payment_gross."', '".$payment_status."', '".$pending_reason."', '".$payment_type."', '".$item_name."', '".$txn_type."', '".$option_selection1."', '".$payment_date."', '".$business."', '".$receiver_id."', '".$notify_version."', '".$custom."', '".$verify_sign."', '".$createdon."','".$promo_code."',0)";
		
		error_log(date('[Y-m-d H:i e] '). " Query: $query ". PHP_EOL, 3, LOG_FILE);
		
		//add gs to gs.au site
		$chances = mysqli_fetch_array(mysqli_query($conn,"SELECT gs_balance FROM golfsurprizes WHERE mob = '".$custom."'"));
		$chances = $chances['gs_balance'];

	    $exists = mysqli_num_rows(mysqli_query($conn,"SELECT id FROM golfsurprizes WHERE mob = '".$custom."'"));
	
		if($exists>0) {
			$newchances = $chances + $option_selection1;
			//update
			mysqli_query($conn,"UPDATE golfsurprizes SET gs_balance = ".$newchances." WHERE mob = '".$custom."'");
		} else {
			//insert
			mysqli_query($conn,"INSERT INTO golfsurprizes VALUES (0, '".$custom."', ".$option_selection1.")");
		}
		
		//Check if user has any record in admin_make_live_persist for this mobile
		$get_persist_record = mysqli_fetch_array(mysqli_query($gs365,"SELECT * FROM admin_make_live_persist WHERE mobile='".$custom."' AND date(created_on)='".date('Y-m-d')."' ORDER BY id DESC LIMIT 0,1"));
		
		if($get_persist_record['mobile']!=="") {
		    mysqli_query($gs365,"INSERT INTO admin_make_live VALUES(
		    0, 
		    '".$get_persist_record['mobile']."',
		    '".$get_persist_record['email']."',
		    '".$get_persist_record['firstname']."',
		    '".$get_persist_record['lastname']."',
		    '".$get_persist_record['sms_date_time']."',
		    '".$get_persist_record['gs_ts']."',
		    '".$get_persist_record['label']."',
		    '".$get_persist_record['clubid']."',
		    '".$get_persist_record['created_on']."',
		    '".$get_persist_record['players']."',
		    2
		    )");
		    
		    //remove all records of this mobile from 
		    mysqli_query($gs365,"DELETE FROM admin_make_live_persist WHERE mobile='".$custom."'");
		    
		    //reduce users balance by 1
		    mysqli_query($conn,"UPDATE golfsurprizes SET gs_balance = gs_balance-1 WHERE mob = '".$custom."'");
		}
	}
	// process payment and mark item as paid.
	//log gs ts credit
	mysqli_query($conn,"INSERT INTO gs_ts_credit_log VALUES(0,'".$custom."','".$option_selection1."','".$option_selection1."','".$createdon."')");
	
	if(DEBUG == true) {
		error_log(date('[Y-m-d H:i e] '). "Verified IPN: $req ". PHP_EOL, 3, LOG_FILE);
	}
	
} else if (strcmp ($res, "INVALID") == 0) {
	// log for manual investigation
	// Add business logic here which deals with invalid IPN messages
	if(DEBUG == true) {
		error_log(date('[Y-m-d H:i e] '). "Invalid IPN: $req" . PHP_EOL, 3, LOG_FILE);
	}
}
?>