<?php 
include 'header.php'; 

// Check if necessary parameters are provided
if(!isset($_GET['id']) || !isset($_GET['uid'])) {
    header('Location: check-mobile.php');
    exit;
}

// Check if user has sufficient balance
if(isset($_GET['uid'])) {
    $balance_query = mysqli_query($conn, "SELECT credits FROM upload_players WHERE email='" . mysqli_real_escape_string($conn, base64_decode($_GET['uid'])) . "'");
    $balance = mysqli_fetch_array($balance_query);
    if($balance['credits'] <= 0) {
        header('Location: buy_credits.php?burl=p');
        exit;
    }
}
if(isset($_GET['uid'])) {
    $balance_query = mysqli_query($conn, "SELECT credits FROM upload_players WHERE email='" . mysqli_real_escape_string($conn, base64_decode($_GET['uid'])) . "'");
    $balance = mysqli_fetch_array($balance_query);
    if($balance['credits'] < intval($_GET['ts']) ) {
        header('Location: buy_credits.php?burl=p');
        exit;
    }
}

// Ensure the number of TS is greater than 0
if($_GET['ts'] <= 0 && $_GET['uid'] !== base64_encode('911@golfsurprize.com')) {
    header('Location: history.php?uid='.$_GET['uid']);
    exit;
}

// Get tournament details
$tournament_date = mysqli_real_escape_string($conn, $_GET['date']);
$tournament_time = mysqli_real_escape_string($conn, $_GET['time']);
$tournament_clubid = mysqli_real_escape_string($conn, $_GET['clubid']);
$tournament_id = mysqli_real_escape_string($conn, $_GET['id']);
$user_email = base64_decode($_GET['uid']);
$datetime_str = date('Y-m-d H:i:s', strtotime("$tournament_date $tournament_time"));

// Get user details
$user_info_query = mysqli_query($conn, "SELECT id, player_name, email FROM upload_players WHERE email='" . $user_email . "'");
$user_info = mysqli_fetch_array($user_info_query);

// Get TS and pack name
$ts = intval($_GET['ts']);
$packname = 'pack'.mysqli_real_escape_string($conn, $_GET['score']);

// Get selected stickers
$get_stickers_query = "
(SELECT sn.*, sn.amount, tpn.stickerid 
 FROM stickers_new sn 
 LEFT JOIN targetscore_player_name tpn ON sn.id = tpn.stickerid 
 WHERE clubid = 1 
 AND packname = '$packname' 
 AND sn.booked = 0 
 ORDER BY sn.booked ASC, sn.id ASC 
 LIMIT 0, $ts)";
$get_stickers = mysqli_query($conn, $get_stickers_query);

$booking_count = 0;
$total_amount = 0; 
$first_sticker_id = null;

// Fetch all selected stickers and calculate total amount
$stickers = [];
while ($sticker = mysqli_fetch_array($get_stickers)) {
    $sticker_id = $sticker['id'];
    if ($first_sticker_id === null) {
        $first_sticker_id = $sticker_id;
    }
    $total_amount += $sticker['amount'];
    $stickers[] = $sticker_id; // here Collect sticker IDs 
}

// Book all stickers and update win_amount
foreach ($stickers as $index => $sticker_id) {
    $sticker_exists_query = mysqli_query($conn, "SELECT id FROM stickers_new WHERE booked=1 AND id=$sticker_id");
    $sticker_exists = mysqli_num_rows($sticker_exists_query);

    if ($sticker_exists == 0) {
        
        if(isset($_GET['uid'])) {
    $balance_query = mysqli_query($conn, "SELECT credits FROM upload_players WHERE email='" . mysqli_real_escape_string($conn, base64_decode($_GET['uid'])) . "'");
    $balance = mysqli_fetch_array($balance_query);
    if($balance['credits'] <= 0) {
        header('Location: buy_credits.php?burl=p');
        exit;
    }
}
        // Book the sticker
        mysqli_query($conn, "UPDATE stickers_new SET chances='$tournament_id', clubid='$tournament_clubid', user_id='" . $user_info['id'] . "', booked=1, barcode='" . $user_info['player_name'] . "', method='" . $user_info['email'] . "', bookedon='$datetime_str' WHERE id=$sticker_id");
        
        // Update user's balance
        mysqli_query($conn, "UPDATE upload_players SET credits=credits-1 WHERE email='$user_email'");
        
        // Update win_amount
        if ($sticker_id == $first_sticker_id) {
            // Update win_amount of the first sticker with total_amount
            mysqli_query($conn, "UPDATE stickers_new SET win_amount='$total_amount' WHERE id=$sticker_id");
        } else {
            // Set win_amount of other stickers to 0
            mysqli_query($conn, "UPDATE stickers_new SET win_amount=0 WHERE id=$sticker_id");
        }
        
        // Insert into tournament_booking
        mysqli_query($conn, "INSERT INTO tournament_booking (id, tournament_id, mobile, joinedon, t_date, t_time, club_id) VALUES (0, '$tournament_id', '$user_email', NOW(), '$tournament_date', '$tournament_time', '$tournament_clubid')");
        
        // Send email to the user
        $book_info_query = mysqli_query($conn, "SELECT score, amount FROM stickers_new WHERE id=" . $sticker_id);
        $book_info = mysqli_fetch_array($book_info_query);
        $created_on_query = mysqli_query($conn, "SELECT t_date FROM tournaments WHERE id='" . mysqli_real_escape_string($conn, $_GET['id']) . "'");
        $created_on = mysqli_fetch_array($created_on_query);
        $to = $user_info['email'];
        $subject = 'Your TargetScore';
        $message = "Hi " . ucwords(strtolower($user_info['player_name'])) . ", <br/><br/>
        Your Target Score for " . date('jS M Y', strtotime($tournament_date)) . " is " . $book_info['score'] . " to win R" . $book_info['amount'] . ".
        <br /><br />
        Play well and tell your friends!";
        $headers = 'From: help@targetscores.com.au' . "\r\n" .
        'Reply-To: help@targetscores.com.au' . "\r\n" .
        'Cc: info@golfsurprize.com' . "\r\n" .
        'Content-type: text/html; charset=iso-8859-1' . "\r\n" .
        'X-Mailer: PHP/' . phpversion();              
        sendMail($to, $subject, $message, $headers);
       
        $booking_count++; 
    }

    // Check if the loop has reached the desired number of bookings
    if ($booking_count >= $ts) {
        break; 
    }
}

// Redirect to history page after booking
header('Location: history.php?uid=' . $_GET['uid']);
exit;

?>
