$(function () {

    // Initialize the jQuery File Upload widget:

    $('#fileupload').fileupload({

        disableImageResize: false,

        // Uncomment the following to send cross-domain cookies:

        //xhrFields: {withCredentials: true},

        url: '../vendors/jquery-file-upload/server/php/'

    });



    // Enable iframe cross-domain access via redirect option:

    $('#fileupload').fileupload(

        'option',

        'redirect',

        window.location.href.replace(

            /\/[^\/]*$/,

            '/cors/result.html?%s'

        )

    );



    // Demo settings:

    $('#fileupload').fileupload('option', {

        url: '../vendors/jquery-file-upload/server/php/',

        // Enable image resizing, except for Android and Opera,

        // which actually support image resizing, but fail to

        // send Blob objects via XHR requests:

        disableImageResize: /Android(?!.*Chrome)|Opera/

            .test(window.navigator.userAgent),

        maxFileSize: 5000000,

        acceptFileTypes: /(\.|\/)(gif|jpe?g|png)$/i

    });

    // Upload server status check for browsers with CORS support:

    if ($.support.cors) {

        $.ajax({

            url: '../vendors/jquery-file-upload/server/php/',

            type: 'HEAD'

        }).fail(function () {

                $('<div class="alert alert-danger"/>')

                    .text('Upload server currently unavailable - ' +

                        new Date())

                    .appendTo('#fileupload');

            });

    }



});