<?php
session_start();

if(!$_SESSION['isadmin']) {
	header("Location: login.php?ref=edit.php?pageid=1");
	exit;
}

if($_SESSION['country_login'] == 1) {
	header("Location: index.php");
	exit;
}

include_once("../functions.php");

$conn = dbconnect();

include "headers/common_header.php";

//get all user details//
$get_users = mysqli_query($conn,"SELECT * FROM prousers");

?>

<!--BEGIN PAGE WRAPPER-->

        <div id="page-wrapper"><!--BEGIN TITLE & BREADCRUMB PAGE-->

            <div id="title-breadcrumb-option-demo" class="page-title-breadcrumb">

                <div class="page-header pull-left">

                    <div class="page-title">ALL Users</div>

                </div>

                <ol class="breadcrumb page-breadcrumb pull-right">

                    <li><i class="fa fa-home"></i>&nbsp;<a href="index.php">Home</a>&nbsp;&nbsp;<i class="fa fa-angle-right"></i>&nbsp;&nbsp;</li>

                    <li class="active">All Users</li>

                </ol>

                <div class="clearfix"></div>

            </div>

            <!--END TITLE & BREADCRUMB PAGE-->

<!--BEGIN CONTENT TABLE-->

            <div class="page-content">

                <div class="row">

                    <div class="col-lg-12">
                         
                        
                        <input type="button" value="Download" id="exporttoexcel" style="float:right;margin-top:5px;margin-right:5px;"/>
                        <input type="button" value="Create PDF" id="btPrint" onclick="createPDF()"style="float:right;margin-top:5px;"/>
                        <input type="button" value="Add User" id="add_user" style="float:right;margin-top:5px;margin-right:5px;"/>
						
                        <div class="panel panel-green" id="mydiv">
	
                            <div class="panel-heading">List of all users</div>

                           <div class="panel-body">

                                <div id="no-more-tables">

                                    <table class="table table-bordered table-striped table-condensed cf" id="users">

                                        <thead class="cf">

                                        <tr>

                                            <th>Sr. No.</th>

                                            <th class="numeric">Name</th>
                                             <th>Mobile</th>
											 <th>Email</th>
                                             <th>Club Name</th>
											<th class="numeric">Status</th>
                                            <th>Register On</th>
                                            <th>last Login</th>
											<th >Action</th>
                                        </tr>

                                        </thead>

										<?php 

                                        $srno = 1;
										
                                        while($user = mysqli_fetch_array($get_users)){
                                        										
										?>
                                        <tbody>

                                        <tr>

                                            <td data-title="Sr. No."><?php echo $srno; ?></td>

                                            <td data-title="Name" class="numeric">
                                            <?php echo ucwords(strtolower($user['proName']))?></td>

                                            <td data-title="Mobile">
                                            <?php echo $user['proMobile']?></td>

											<td data-title="Email">
                                            <?php echo strtolower($user['proEmail'])?></td>

											<td data-title="Clubname">
                                            <?php echo $user['proClubname']?></td>

											<td data-title="Status">
                                            <?php echo $user['active']?></td>
                                            
											<td data-title="Register On">
                                            <?php echo date('jS M Y h:i A',strtotime($user['registerOn']))?></td>

											<td data-title="Last Login">
                                            <?php if($user['last_login'] == '0000-00-00 00:00:00'){
                                                echo $user['last_login'];
                                            }else{
                                                echo date('jS M Y h:i A',strtotime($user['last_login']));
                                            }?></td>

                                            <td data-title="Action">
                                            <a href="edit_user.php?id=<?php echo $user['id']?>" title="Edit" class="btn-orange btn-xs"><i class="fa fa-pencil"></i>&nbsp;Edit</a>
                                            </td> 
                                        </tr>

                                        </tbody>

										<?php $srno++;}?>
										
                                    </table>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

            <!--END CONTENT-->

<script>
function PrintElem(elem)
    {
        Popup($(elem).html());
    }

    function Popup(data) 
    {
        var mywindow = window.open('', 'targetscores.com.au', 'height=400,width=800');
        mywindow.document.write('<html><head><title>All pro Users</title>');
        /*optional stylesheet*/ //mywindow.document.write('<link rel="stylesheet" href="main.css" type="text/css" />');
		
        mywindow.document.write('</head><body >');
        mywindow.document.write(data);
        mywindow.document.write('</body></html>');

        mywindow.document.close(); // necessary for IE >= 10
        mywindow.focus(); // necessary for IE >= 10

        mywindow.print();
        mywindow.close();

        return true;
    }
</script>
 <script src= "//cdn.rawgit.com/rainabba/jquery-table2excel/1.1.0/dist/jquery.table2excel.min.js"></script> 
            <script>
                $(document).ready(function() {
                    $("#exporttoexcel").click(function(){
                        $("#users").table2excel({
                            filename: "pro_users",
                        });
                    });
                });
</script>
<script>
    function createPDF() {
        var sTable = document.getElementById('mydiv').innerHTML;

        var style = "<style>";
        style = style + "table {width: 100%;font: 17px Calibri;}";
        style = style + "table, th, td {border: solid 1px #DDD; border-collapse: collapse;";
        style = style + "padding: 2px 3px;text-align: center;}";
        style = style + "</style>";

        // CREATE A WINDOW OBJECT.
        var win = window.open('', '', 'height=700,width=700');

        win.document.write('<html><head>');
        win.document.write('<title>Pro Users</title>');   // <title> FOR PDF HEADER.
        win.document.write(style);          // ADD STYLE INSIDE THE HEAD TAG.
        win.document.write('</head>');
        win.document.write('<body>');
        win.document.write(sTable);         // THE TABLE CONTENTS INSIDE THE BODY TAG.
        win.document.write('</body></html>');

        win.document.close(); 	// CLOSE THE CURRENT WINDOW.

        win.print();    // PRINT THE CONTENTS.
    }
</script>
<script>
document.getElementById("add_user").addEventListener("click", function() {
    window.location.href = "add_user.php"
});
</script>

<?php include "footer.php";?>