<?php
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace SquareConnect\Model;

use \ArrayAccess;
/**
 * BankAccount Class Doc Comment
 *
 * @category Class
 * @package  SquareConnect
 * @author   Square Inc.
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache License v2
 * @link     https://squareup.com/developers
 */
class BankAccount implements ArrayAccess
{
    /**
      * Array of property to type mappings. Used for (de)serialization 
      * @var string[]
      */
    static $swaggerTypes = array(
        'id' => 'string',
        'account_number_suffix' => 'string',
        'country' => 'string',
        'currency' => 'string',
        'account_type' => 'string',
        'holder_name' => 'string',
        'primary_bank_identification_number' => 'string',
        'secondary_bank_identification_number' => 'string',
        'debit_mandate_reference_id' => 'string',
        'reference_id' => 'string',
        'location_id' => 'string',
        'status' => 'string',
        'creditable' => 'bool',
        'debitable' => 'bool',
        'fingerprint' => 'string',
        'version' => 'int',
        'bank_name' => 'string'
    );
  
    /** 
      * Array of attributes where the key is the local name, and the value is the original name
      * @var string[] 
      */
    static $attributeMap = array(
        'id' => 'id',
        'account_number_suffix' => 'account_number_suffix',
        'country' => 'country',
        'currency' => 'currency',
        'account_type' => 'account_type',
        'holder_name' => 'holder_name',
        'primary_bank_identification_number' => 'primary_bank_identification_number',
        'secondary_bank_identification_number' => 'secondary_bank_identification_number',
        'debit_mandate_reference_id' => 'debit_mandate_reference_id',
        'reference_id' => 'reference_id',
        'location_id' => 'location_id',
        'status' => 'status',
        'creditable' => 'creditable',
        'debitable' => 'debitable',
        'fingerprint' => 'fingerprint',
        'version' => 'version',
        'bank_name' => 'bank_name'
    );
  
    /**
      * Array of attributes to setter functions (for deserialization of responses)
      * @var string[]
      */
    static $setters = array(
        'id' => 'setId',
        'account_number_suffix' => 'setAccountNumberSuffix',
        'country' => 'setCountry',
        'currency' => 'setCurrency',
        'account_type' => 'setAccountType',
        'holder_name' => 'setHolderName',
        'primary_bank_identification_number' => 'setPrimaryBankIdentificationNumber',
        'secondary_bank_identification_number' => 'setSecondaryBankIdentificationNumber',
        'debit_mandate_reference_id' => 'setDebitMandateReferenceId',
        'reference_id' => 'setReferenceId',
        'location_id' => 'setLocationId',
        'status' => 'setStatus',
        'creditable' => 'setCreditable',
        'debitable' => 'setDebitable',
        'fingerprint' => 'setFingerprint',
        'version' => 'setVersion',
        'bank_name' => 'setBankName'
    );
  
    /**
      * Array of attributes to getter functions (for serialization of requests)
      * @var string[]
      */
    static $getters = array(
        'id' => 'getId',
        'account_number_suffix' => 'getAccountNumberSuffix',
        'country' => 'getCountry',
        'currency' => 'getCurrency',
        'account_type' => 'getAccountType',
        'holder_name' => 'getHolderName',
        'primary_bank_identification_number' => 'getPrimaryBankIdentificationNumber',
        'secondary_bank_identification_number' => 'getSecondaryBankIdentificationNumber',
        'debit_mandate_reference_id' => 'getDebitMandateReferenceId',
        'reference_id' => 'getReferenceId',
        'location_id' => 'getLocationId',
        'status' => 'getStatus',
        'creditable' => 'getCreditable',
        'debitable' => 'getDebitable',
        'fingerprint' => 'getFingerprint',
        'version' => 'getVersion',
        'bank_name' => 'getBankName'
    );
  
    /**
      * $id The unique, Square-issued identifier for the bank account.
      * @var string
      */
    protected $id;
    /**
      * $account_number_suffix The last few digits of the account number.
      * @var string
      */
    protected $account_number_suffix;
    /**
      * $country The ISO 3166 Alpha-2 country code where the bank account is based. See [Country](#type-country) for possible values
      * @var string
      */
    protected $country;
    /**
      * $currency The 3-character ISO 4217 currency code indicating the operating currency of the bank account. For example, the currency code for US dollars is `USD`. See [Currency](#type-currency) for possible values
      * @var string
      */
    protected $currency;
    /**
      * $account_type The financial purpose of the associated bank account. See [BankAccountType](#type-bankaccounttype) for possible values
      * @var string
      */
    protected $account_type;
    /**
      * $holder_name Name of the account holder. This name must match the name  on the targeted bank account record.
      * @var string
      */
    protected $holder_name;
    /**
      * $primary_bank_identification_number Primary identifier for the bank. For more information, see  [Bank Accounts API](https://developer.squareup.com/docs/docs/bank-accounts-api).
      * @var string
      */
    protected $primary_bank_identification_number;
    /**
      * $secondary_bank_identification_number Secondary identifier for the bank. For more information, see  [Bank Accounts API](https://developer.squareup.com/docs/docs/bank-accounts-api).
      * @var string
      */
    protected $secondary_bank_identification_number;
    /**
      * $debit_mandate_reference_id Reference identifier that will be displayed to UK bank account owners when collecting direct debit authorization. Only required for UK bank accounts.
      * @var string
      */
    protected $debit_mandate_reference_id;
    /**
      * $reference_id Client-provided identifier for linking the banking account to an entity in a third-party system (for example, a bank account number or a user identifier).
      * @var string
      */
    protected $reference_id;
    /**
      * $location_id The location to which the bank account belongs.
      * @var string
      */
    protected $location_id;
    /**
      * $status Read-only. The current verification status of this BankAccount object. See [BankAccountStatus](#type-bankaccountstatus) for possible values
      * @var string
      */
    protected $status;
    /**
      * $creditable Indicates whether it is possible for Square to send money to this bank account.
      * @var bool
      */
    protected $creditable;
    /**
      * $debitable Indicates whether it is possible for Square to take money from this  bank account.
      * @var bool
      */
    protected $debitable;
    /**
      * $fingerprint A Square-assigned, unique identifier for the bank account based on the account information. The account fingerprint can be used to compare account entries and determine if the they represent the same real-world bank account.
      * @var string
      */
    protected $fingerprint;
    /**
      * $version The current version of the `BankAccount`.
      * @var int
      */
    protected $version;
    /**
      * $bank_name Read only. Name of actual financial institution.  For example \"Bank of America\".
      * @var string
      */
    protected $bank_name;

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initializing the model
     */
    public function __construct(array $data = null)
    {
        if ($data != null) {
            if (isset($data["id"])) {
              $this->id = $data["id"];
            } else {
              $this->id = null;
            }
            if (isset($data["account_number_suffix"])) {
              $this->account_number_suffix = $data["account_number_suffix"];
            } else {
              $this->account_number_suffix = null;
            }
            if (isset($data["country"])) {
              $this->country = $data["country"];
            } else {
              $this->country = null;
            }
            if (isset($data["currency"])) {
              $this->currency = $data["currency"];
            } else {
              $this->currency = null;
            }
            if (isset($data["account_type"])) {
              $this->account_type = $data["account_type"];
            } else {
              $this->account_type = null;
            }
            if (isset($data["holder_name"])) {
              $this->holder_name = $data["holder_name"];
            } else {
              $this->holder_name = null;
            }
            if (isset($data["primary_bank_identification_number"])) {
              $this->primary_bank_identification_number = $data["primary_bank_identification_number"];
            } else {
              $this->primary_bank_identification_number = null;
            }
            if (isset($data["secondary_bank_identification_number"])) {
              $this->secondary_bank_identification_number = $data["secondary_bank_identification_number"];
            } else {
              $this->secondary_bank_identification_number = null;
            }
            if (isset($data["debit_mandate_reference_id"])) {
              $this->debit_mandate_reference_id = $data["debit_mandate_reference_id"];
            } else {
              $this->debit_mandate_reference_id = null;
            }
            if (isset($data["reference_id"])) {
              $this->reference_id = $data["reference_id"];
            } else {
              $this->reference_id = null;
            }
            if (isset($data["location_id"])) {
              $this->location_id = $data["location_id"];
            } else {
              $this->location_id = null;
            }
            if (isset($data["status"])) {
              $this->status = $data["status"];
            } else {
              $this->status = null;
            }
            if (isset($data["creditable"])) {
              $this->creditable = $data["creditable"];
            } else {
              $this->creditable = null;
            }
            if (isset($data["debitable"])) {
              $this->debitable = $data["debitable"];
            } else {
              $this->debitable = null;
            }
            if (isset($data["fingerprint"])) {
              $this->fingerprint = $data["fingerprint"];
            } else {
              $this->fingerprint = null;
            }
            if (isset($data["version"])) {
              $this->version = $data["version"];
            } else {
              $this->version = null;
            }
            if (isset($data["bank_name"])) {
              $this->bank_name = $data["bank_name"];
            } else {
              $this->bank_name = null;
            }
        }
    }
    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
  
    /**
     * Sets id
     * @param string $id The unique, Square-issued identifier for the bank account.
     * @return $this
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Gets account_number_suffix
     * @return string
     */
    public function getAccountNumberSuffix()
    {
        return $this->account_number_suffix;
    }
  
    /**
     * Sets account_number_suffix
     * @param string $account_number_suffix The last few digits of the account number.
     * @return $this
     */
    public function setAccountNumberSuffix($account_number_suffix)
    {
        $this->account_number_suffix = $account_number_suffix;
        return $this;
    }
    /**
     * Gets country
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }
  
    /**
     * Sets country
     * @param string $country The ISO 3166 Alpha-2 country code where the bank account is based. See [Country](#type-country) for possible values
     * @return $this
     */
    public function setCountry($country)
    {
        $this->country = $country;
        return $this;
    }
    /**
     * Gets currency
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }
  
    /**
     * Sets currency
     * @param string $currency The 3-character ISO 4217 currency code indicating the operating currency of the bank account. For example, the currency code for US dollars is `USD`. See [Currency](#type-currency) for possible values
     * @return $this
     */
    public function setCurrency($currency)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Gets account_type
     * @return string
     */
    public function getAccountType()
    {
        return $this->account_type;
    }
  
    /**
     * Sets account_type
     * @param string $account_type The financial purpose of the associated bank account. See [BankAccountType](#type-bankaccounttype) for possible values
     * @return $this
     */
    public function setAccountType($account_type)
    {
        $this->account_type = $account_type;
        return $this;
    }
    /**
     * Gets holder_name
     * @return string
     */
    public function getHolderName()
    {
        return $this->holder_name;
    }
  
    /**
     * Sets holder_name
     * @param string $holder_name Name of the account holder. This name must match the name  on the targeted bank account record.
     * @return $this
     */
    public function setHolderName($holder_name)
    {
        $this->holder_name = $holder_name;
        return $this;
    }
    /**
     * Gets primary_bank_identification_number
     * @return string
     */
    public function getPrimaryBankIdentificationNumber()
    {
        return $this->primary_bank_identification_number;
    }
  
    /**
     * Sets primary_bank_identification_number
     * @param string $primary_bank_identification_number Primary identifier for the bank. For more information, see  [Bank Accounts API](https://developer.squareup.com/docs/docs/bank-accounts-api).
     * @return $this
     */
    public function setPrimaryBankIdentificationNumber($primary_bank_identification_number)
    {
        $this->primary_bank_identification_number = $primary_bank_identification_number;
        return $this;
    }
    /**
     * Gets secondary_bank_identification_number
     * @return string
     */
    public function getSecondaryBankIdentificationNumber()
    {
        return $this->secondary_bank_identification_number;
    }
  
    /**
     * Sets secondary_bank_identification_number
     * @param string $secondary_bank_identification_number Secondary identifier for the bank. For more information, see  [Bank Accounts API](https://developer.squareup.com/docs/docs/bank-accounts-api).
     * @return $this
     */
    public function setSecondaryBankIdentificationNumber($secondary_bank_identification_number)
    {
        $this->secondary_bank_identification_number = $secondary_bank_identification_number;
        return $this;
    }
    /**
     * Gets debit_mandate_reference_id
     * @return string
     */
    public function getDebitMandateReferenceId()
    {
        return $this->debit_mandate_reference_id;
    }
  
    /**
     * Sets debit_mandate_reference_id
     * @param string $debit_mandate_reference_id Reference identifier that will be displayed to UK bank account owners when collecting direct debit authorization. Only required for UK bank accounts.
     * @return $this
     */
    public function setDebitMandateReferenceId($debit_mandate_reference_id)
    {
        $this->debit_mandate_reference_id = $debit_mandate_reference_id;
        return $this;
    }
    /**
     * Gets reference_id
     * @return string
     */
    public function getReferenceId()
    {
        return $this->reference_id;
    }
  
    /**
     * Sets reference_id
     * @param string $reference_id Client-provided identifier for linking the banking account to an entity in a third-party system (for example, a bank account number or a user identifier).
     * @return $this
     */
    public function setReferenceId($reference_id)
    {
        $this->reference_id = $reference_id;
        return $this;
    }
    /**
     * Gets location_id
     * @return string
     */
    public function getLocationId()
    {
        return $this->location_id;
    }
  
    /**
     * Sets location_id
     * @param string $location_id The location to which the bank account belongs.
     * @return $this
     */
    public function setLocationId($location_id)
    {
        $this->location_id = $location_id;
        return $this;
    }
    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
  
    /**
     * Sets status
     * @param string $status Read-only. The current verification status of this BankAccount object. See [BankAccountStatus](#type-bankaccountstatus) for possible values
     * @return $this
     */
    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Gets creditable
     * @return bool
     */
    public function getCreditable()
    {
        return $this->creditable;
    }
  
    /**
     * Sets creditable
     * @param bool $creditable Indicates whether it is possible for Square to send money to this bank account.
     * @return $this
     */
    public function setCreditable($creditable)
    {
        $this->creditable = $creditable;
        return $this;
    }
    /**
     * Gets debitable
     * @return bool
     */
    public function getDebitable()
    {
        return $this->debitable;
    }
  
    /**
     * Sets debitable
     * @param bool $debitable Indicates whether it is possible for Square to take money from this  bank account.
     * @return $this
     */
    public function setDebitable($debitable)
    {
        $this->debitable = $debitable;
        return $this;
    }
    /**
     * Gets fingerprint
     * @return string
     */
    public function getFingerprint()
    {
        return $this->fingerprint;
    }
  
    /**
     * Sets fingerprint
     * @param string $fingerprint A Square-assigned, unique identifier for the bank account based on the account information. The account fingerprint can be used to compare account entries and determine if the they represent the same real-world bank account.
     * @return $this
     */
    public function setFingerprint($fingerprint)
    {
        $this->fingerprint = $fingerprint;
        return $this;
    }
    /**
     * Gets version
     * @return int
     */
    public function getVersion()
    {
        return $this->version;
    }
  
    /**
     * Sets version
     * @param int $version The current version of the `BankAccount`.
     * @return $this
     */
    public function setVersion($version)
    {
        $this->version = $version;
        return $this;
    }
    /**
     * Gets bank_name
     * @return string
     */
    public function getBankName()
    {
        return $this->bank_name;
    }
  
    /**
     * Sets bank_name
     * @param string $bank_name Read only. Name of actual financial institution.  For example \"Bank of America\".
     * @return $this
     */
    public function setBankName($bank_name)
    {
        $this->bank_name = $bank_name;
        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset 
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->$offset);
    }
  
    /**
     * Gets offset.
     * @param  integer $offset Offset 
     * @return mixed 
     */
    public function offsetGet($offset)
    {
        return $this->$offset;
    }
  
    /**
     * Sets value based on offset.
     * @param  integer $offset Offset 
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        $this->$offset = $value;
    }
  
    /**
     * Unsets offset.
     * @param  integer $offset Offset 
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->$offset);
    }
  
    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        } else {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this));
        }
    }
}
