<?php
// Connection
session_start(); 
date_default_timezone_set("Australia/Sydney");
ini_set("date.timezone","Australia/Sydney");
include_once("../functions.php");
$conn = dbconnect();

// Get clubid from URL
$clubid = isset($_GET['clubid']) ? intval($_GET['clubid']) : 1; // Default to 1 if not provided

$table_name = 'stickers_new';

$filename = "players_data_" . $clubid; // Set dynamic file name based on clubid
// Download file headers
header("Content-Type: application/vnd.ms-excel");
header("Content-disposition: attachment; filename=".$filename.".xls");

// Modify the query with the dynamic clubid
$get_players = mysqli_query($conn, "
    SELECT up.id, up.player_name, up.email, up.mobile, up.addedon, up.credits, 
           COUNT(ts.id) AS ts_used, SUM(ts.winner) AS ts_won 
    FROM upload_players up 
    LEFT JOIN stickers_new ts ON up.id = ts.user_id 
    WHERE up.clubid = $clubid 
    GROUP BY up.id 
    ORDER BY up.id ASC
");

// Write data to file
$flag = false;
while ($row = mysqli_fetch_assoc($get_players)) {
    if (!$flag) {
        // Display field/column names as first row
        echo implode("\t", array_keys($row)) . "\r\n";
        $flag = true;
    }
    // Display row data
    echo implode("\t", array_values($row)) . "\r\n";
}
?>
